%% Script that generates Figures of Head Tracking analysis
clear,clc,close all

%% Load data & Variables initialization
load('Averaged_Histograms')
edges = -125:2.5:75;
FS = 10;

%% STD processing
STD_Av = nan(32,2);
STD_Av(:,1) = (1:32)';
for k=1:32
    pos = find(STD(:,1)-k == 0);
    STD_Av(k,2) = nanmean(STD(pos,2));
end
STD_NH  = nanmean(STD_Av(1:16,2));
STD_UHL = nanmean(STD_Av(17:32,2));
[~,p_STD] = ttest2(STD_Av(1:16,2),STD_Av(17:32,2));

%% Print figure
figure('PaperSize',[10 8]),hold on,box on,grid on
hv(1) = histogram('BinEdges',edges,'BinCounts',H_NH*100);
hv(2) = histogram('BinEdges',edges,'BinCounts',H_UHL*100);
plot([22.5 22.5],[0 8],'Color',[12,224,36]/255,'LineWidth',2)
plot([-45 -45],[0 8],'Color',[12,224,36]/255,'LineWidth',2)

text(25,5.5,'Speaker 1','FontSize',FS-1,'HorizontalAlignment','left')
text(25,4.5,'(better ear)','FontSize',FS-1,'HorizontalAlignment','left')
text(-48,5.5,'Speaker 2','FontSize',FS-1,'HorizontalAlignment','right')
text(-48,4.5,'(worse ear)','FontSize',FS-1,'HorizontalAlignment','right')
% text(-125,11,'STD_{NH} = 10.4^{\circ}','FontSize',FS-1)
% text(-125,9.5,'STD_{UHL} = 20.4^{\circ}','FontSize',FS-1)
% text(-125,8.0,'p = 8·10^{-6}','FontSize',FS-1)

lgnd = legend(hv,'NH','UHL');
set(lgnd,'FontSize',FS-2)
set(gca,'xtick',-120:40:80,'FontSize',FS-1)

ylabel('Percentage of time (%)','FontSize',FS)
xlabel('Head orientation (degrees)','FontSize',FS)
title('Head tracking','FontSize',FS)

orient tall
print('-dpng','-r600','Figure5')
print('-dpdf','-r600','Figure5')
close all
